function AISMN_GatherWorkObject::OnEnter(%this,%obj)
{
   %workplace = GetWorkplace(%obj);
   if(0 != %workplace)
   {
      %component = slgQueryInterface(%workplace, $CID_BUILDING);
      //If there's no component, report an error. 
      if (!%component)
      {
         SetStateVariable(%obj,0,1.0);
         return;
      }
      
      %animation = %component.getWorkAnimation();
      if (strlen(%animation) == 0)
      {
         SetStateVariable(%obj,0,2.0);
         return;
      }
      GetThisObject(%obj).playThread( 0, %animation);
   }
}

function AISMN_GatherWorkObject::OnExit(%this,%obj)
{
   //Reset the animation
   GetThisObject(%obj).playThread( 0, "root");
   
   %workplace = GetWorkplace(%obj);
   if(0 != %workplace)
   {
      %component = slgQueryInterface(%workplace, $CID_BUILDING);
      //If there's no component, report an error. 
      if (!%component)
      {
         return;
      }
      
      %mount = %component.getWorkGatherMount();
      if(0 != %mount)
      {
         GetThisObject(%obj).mountImage(%mount,1);
      }
   }
}

//EXIT 0: WORKPLACE DOES NOT EXIST
//EXIT 1: DONE GATHERING
function AISMN_GatherWorkObject::Update(%this,%obj)
{
   %workplace = GetWorkplace(%obj);
   
   //Check if the work place still exists.
   if (%workplace == 0 || GetStateVariable(%obj,0) > 0)
   {
      ReturnValue(%obj,0);
      return;
   }
   
   //If we've stayed here animating for long enough, leave.
   if (TimeInNode(%obj) >= 20.0)
   {
      ReturnValue(%obj,1);
      return;
   }
   
   ReturnValue(%obj,-1);
}
